<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class TipoSolicitud extends Model 
{

    protected $table = 'tipo_solicitudes';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'code', 'modulos_id');
    protected $visible = array('name', 'code', 'modulos_id');

    public function modulo()
    {
        return $this->belongsTo('Modulo', 'modulo_id')->withTrashed();
    }

}